class DM_SB extends TournamentScoreBoard;

#exec Texture Import File=Textures\FrameDot.bmp Name=FrameDot Group=HUD MIPS=ON

var bool bSetStart;
var float Speed, a, b;

var localized string MapTitle, Author, Restart, Continue, Ended, ElapsedTime, RemainingTime, FragGoal, TimeLimit;
var localized string PlayerString, FragsString, DeathsString, PingString;
var localized string TimeString, LossString, FPHString;
var color GreenColor, WhiteColor, GoldColor, BlueColor, LightCyanColor, SilverColor, BronzeColor, CyanColor, RedColor;
var PlayerReplicationInfo Ordered[32];
var float ScoreStart,X1,X2,X3,X4;	// top allowed score start
var bool bTimeDown;
var FontInfo MyFonts;
var localized string MapTitleQuote;

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function PostBeginPlay()
{
	Super.PostBeginPlay();
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(class'ChallengeHUD'.default.FontInfoClass, class'Class'))));
}

function DrawHeader( canvas Canvas )
{
	local GameReplicationInfo GRI;
	local float XL, YL;

	Canvas.DrawColor = WhiteColor;
	GRI = PlayerPawn(Owner).GameReplicationInfo;

	Canvas.Font = MyFonts.GetHugeFont(Canvas.ClipX);

	Canvas.bCenter = True;

	if ( GRI.GameEndedComments != "" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, 0);
		Canvas.DrawText(GRI.GameEndedComments, True);
		}
	else
		{
		DrawVictoryConditions(Canvas);
		}
	Canvas.bCenter = False;
}

function DrawVictoryConditions(Canvas Canvas)
{
	local TournamentGameReplicationInfo TGRI;
	local float XL, YL;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;

	Canvas.SetPos(0, 0);
	Canvas.DrawText(TGRI.GameName);
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	Canvas.SetPos(0, 32);

	if ( TGRI.FragLimit > 0 )
	{
		Canvas.DrawText(FragGoal@TGRI.FragLimit);
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, 54);
	}

	if ( TGRI.TimeLimit > 0 )
		Canvas.DrawText(TimeLimit@TGRI.TimeLimit$":00");
}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

function DrawTrailer( canvas Canvas )
{
	local int Hours, Minutes, Seconds;
	local float XL, YL;
	local PlayerPawn PlayerOwner;

	Canvas.bCenter = true;
	Canvas.StrLen("Test", XL, YL);
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);
	Canvas.SetPos(0, Canvas.ClipY - 2 * YL);
	if ( (Level.NetMode == NM_Standalone) && Level.Game.IsA('DeathMatchPlus') )
	{
		if ( DeathMatchPlus(Level.Game).bRatedGame )
			Canvas.DrawText(DeathMatchPlus(Level.Game).RatedGameLadderObj.SkillText@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else if ( DeathMatchPlus(Level.Game).bNoviceMode ) 
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else  
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty + 4]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
	}
	else
		Canvas.DrawText(PlayerOwner.GameReplicationInfo.GameName@MapTitle@Level.Title, true);

	Canvas.SetPos(0, Canvas.ClipY - YL);
	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
	{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			Canvas.DrawText(RemainingTime@"00:00", true);
		else
		{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.DrawText(RemainingTime@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
	}
	else
	{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.DrawText(ElapsedTime@TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
	}

	if ( PlayerOwner.GameReplicationInfo.GameEndedComments != "" )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		if ( Level.NetMode == NM_Standalone )
			Canvas.DrawText(Ended@Continue, true);
		else
			Canvas.DrawText(Ended, true);
	}
	else if ( (PlayerOwner != None) && (PlayerOwner.Health <= 0) )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText(Restart, true);
	}
	Canvas.bCenter = false;
}

simulated function DrawHeadlines(Canvas Canvas)
{
local float Y;
local Pawn P;

	P = PlayerPawn(Owner);

	X1 = Canvas.ClipX / 5;
	X2 = X1 * 3;
	X3 = X1 * 3.5;
	X4 = X1 * 4;
	Y = 80;

	Canvas.DrawColor = WhiteColor;

	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	Canvas.Style = ERenderStyle.STY_Normal;

	Canvas.SetPos(X1, Y);
	Canvas.DrawText(PRI(P.PlayerReplicationInfo).NameString, False);
	Canvas.SetPos(X2, Y);
	Canvas.DrawText(PRI(P.PlayerReplicationInfo).FragString, False);
	Canvas.SetPos(X3, Y);
	Canvas.DrawText(PRI(P.PlayerReplicationInfo).DeathString, False);
	Canvas.SetPos(X4, Y);
	Canvas.DrawText(PRI(P.PlayerReplicationInfo).ScoreString, False);
}

simulated function DrawPlayerStats(Canvas Canvas, PlayerReplicationInfo PRInfo, float XOffset, float YOffset, bool bCompressed)
{
local float XL, YL, XL2, YL2, XL3, YL3;
local Font CanvasFont;
local bool bLocalPlayer;
local PlayerPawn PlayerOwner;
local int Time;
local int Eff;
local String ImportTexture;
local Texture FLag;

	//Draw Background
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor.R = 50;
	Canvas.DrawColor.G = 50;
	Canvas.DrawColor.B = 50;
	Canvas.SetPos(X1 - 52, YOffset + 2);
	Canvas.DrawTile(Texture'FrameDot', 3 * X1 + 0.33 * X1, 36, 0, 0, 2, 2);


	PlayerOwner = PlayerPawn(Owner);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	bLocalPlayer = (PRInfo.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);

	//Draw Country Flag:
	if ( PRInfo.bIsABot )
		{
		Canvas.SetPos(X1 - 50, YOffset + 4);
		Canvas.DrawTile(Texture'BotFlag', 48, 32, 0, 0, 48, 32);
		}
	else if ( PRI(PRInfo).Country != "" )
		{
		ImportTexture = "MOS_HASM_v1.Flags."$PRI(PRInfo).Country;
		Flag = texture(DynamicLoadObject(ImportTexture, class'Texture'));
		Canvas.SetPos(X1 - 50, YOffset + 4);
		if ( Flag != None )
			Canvas.DrawTile(Flag, 48, 32, 0, 0, 48, 32);
		}
	else
		{
		Canvas.SetPos(X1 - 50, YOffset + 4);
		Canvas.DrawTile(Texture'NoFlag', 48, 32, 0, 0, 48, 32);
		}


	if ( bLocalPlayer ) 
		Canvas.DrawColor = GoldColor;
	else 
		Canvas.DrawColor = GreenColor;

	Canvas.SetPos(X1, YOffset);
	Canvas.DrawText(PRInfo.PlayerName, False);

	Canvas.SetPos(X2, YOffset);
	Canvas.DrawText( int(PRInfo.Score), false );

	Canvas.SetPos(X3, YOffset);
	Canvas.DrawText( int(PRInfo.Deaths), false );

	Canvas.SetPos(X4, YOffset);
	Canvas.DrawText( int(PRInfo.Score - PRInfo.Deaths), false );

	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallestFont(Canvas.ClipX);
	Canvas.StrLen("Test", XL, YL);

	Time = Max(1, (Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRInfo.StartTime)/60);

	if ( PRInfo.Score < 0 )
		Eff = 0;
	else
		Eff = PRInfo.Score / (PRInfo.Score + PRInfo.Deaths) * 100;

	// Draw Misc
	if ( !PRInfo.bIsABot )
		{
		Canvas.SetPos(X1, YOffset + 40 - YL );
		Canvas.DrawText("Headshots:"@PRI(PRInfo).Headshots$", Suicides:"@PRI(PRInfo).Suicides$", Eff:"@Eff$"%, FPH:"@int(60 * PRInfo.Score/Time)$", Time:"@Time$", Ping"@PRInfo.Ping, false );
		}
	else
		{
		Canvas.SetPos(X1, YOffset + 40 - YL );
		Canvas.DrawText( "EFF: "@Eff$"%, FPH:"@int(60 * PRInfo.Score/Time)$", Time:"@Time, false );
		}

}

function SortScores(int N)
{
local int I, J, Max;
local PlayerReplicationInfo TempPRI;
local float JScore, MaxScore;

	for ( I=0; I<N-1; I++ )
		{
		Max = I;
		for ( J=I+1; J<N; J++ )
			{
			JScore = Ordered[J].Score - Ordered[J].Deaths;
			MaxScore = Ordered[Max].Score - Ordered[Max].Deaths;

			if ( JScore > MaxScore )
				Max = J;
			else if ((JScore == MaxScore) && (Ordered[J].Deaths < Ordered[Max].Deaths))
				Max = J;
			else if ((JScore == MaxScore) && (Ordered[J].Deaths == Ordered[Max].Deaths) && (Ordered[J].PlayerID < Ordered[Max].Score))
				Max = J;
			}
		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
		}

/*
	for ( I=0; I<N-1; I++ )
		{
		Max = I;
		for ( J=I+1; J<N; J++ )
			{
			if ( Ordered[J].Score > Ordered[Max].Score )
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths < Ordered[Max].Deaths))
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths == Ordered[Max].Deaths) && (Ordered[J].PlayerID < Ordered[Max].Score))
				Max = J;
			}
		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
		}
*/
}

function ShowScores( canvas Canvas )
{
	local PlayerReplicationInfo PRI;
	local int PlayerCount, i;
	local float XL, YL, Scale;
	local float YOffset, YStart;

	Canvas.Style = ERenderStyle.STY_Normal;

	// Wipe everything.
	for ( i=0; i<ArrayCount(Ordered); i++ )
		Ordered[i] = None;
	for ( i=0; i<32; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bIsSpectator || PRI.bWaitingPlayer )
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				if ( PlayerCount == ArrayCount(Ordered) )
					break;
			}
		}
	}
	SortScores(PlayerCount);
	DrawHeader(Canvas);
	DrawHeadlines(Canvas);

	YOffset = 108;

	for ( I=0; I<PlayerCount; I++ )
	{
		if ( YOffset < Canvas.ClipY - 85 )
			DrawPlayerStats( Canvas, Ordered[I], 0, YOffset, false );
		YOffset += 40;
	}
	Canvas.DrawColor = WhiteColor;

	// Trailer
	if ( !Level.bLowRes )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		DrawTrailer(Canvas);
	}
	Canvas.DrawColor = WhiteColor;

}

defaultproperties
{
     MapTitle="in"
     Author="by"
     Restart="You are dead.  Hit [Fire] to respawn!"
     Continue=" Hit [Fire] to continue!"
     Ended="The match has ended."
     ElapsedTime="Elapsed Time: "
     RemainingTime="Remaining Time: "
     FragGoal="Score Limit:"
     TimeLimit="Time Limit:"
     PlayerString="Player"
     FragsString="Frags"
     DeathsString="Deaths"
     PingString="Ping"
     TimeString="Time"
     LossString="Loss"
     FPHString="FPH"
     GreenColor=(G=255)
     WhiteColor=(R=255,G=255,B=255)
     GoldColor=(R=255,G=255)
     BlueColor=(B=255)
     LightCyanColor=(R=128,G=255,B=255)
     SilverColor=(R=138,G=164,B=166)
     BronzeColor=(R=203,G=147,B=52)
     CyanColor=(G=128,B=255)
     RedColor=(R=255)
     bSetStart=False
}
